package ga.examples.quadratic;

import ga.core.evaluation.IFitnessEvaluator;

public class QuadraticClusterEvaluator implements
    IFitnessEvaluator<QuadraticClusterIndividual> {

  private final int target;

  public QuadraticClusterEvaluator(final int target) {
    this.target = target;
  }

  public int getTarget() {
    return target;
  }

  @Override
  public void evaluate(final QuadraticClusterIndividual individual) {
    final int a = individual.getGenotype().get(0);
    final int b = individual.getGenotype().get(1);
    final int c = individual.getGenotype().get(2);
    final int result = (int) Math.pow(a, 2) * b + c;

    final double fitness = result == target ? 1d : 1d / Math.abs(result
        - target);

    individual.setResult(result);
    individual.setFitness(fitness);
  }
}
